unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, IdAntiFreezeBase, IdAntiFreeze, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient;

type
  TMain1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    eIPAddress: TEdit;
    sePort1: TSpinEdit;
    bConnect: TButton;
    GroupBox2: TGroupBox;
    Memo1: TMemo;
    GroupBox3: TGroupBox;
    Memo2: TMemo;
    TCPClient: TIdTCPClient;
    IdAntiFreeze: TIdAntiFreeze;
    bLogin: TButton;
    mSLog: TMemo;
    procedure bConnectClick(Sender: TObject);
    procedure TCPClientConnected(Sender: TObject);
    procedure TCPClientDisconnected(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bLoginClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SendRequest(strRequest,strReceive:TStringList);
  end;

var
  Main1: TMain1;
  isConnected, isLogin : boolean;
  ClientString,LoginString:TStringList;

  //SGC Login Variables
  cEncryptionType:string;
  cUserID,cPassword,cCompanyCode,
  cProgramType, cProgramCode:string;
  
implementation

{$R *.dfm}
procedure TMain1.SendRequest(strRequest,strReceive:TStringList);
var strTemp : string;
    whileLimit : Extended;
begin
  whileLimit:=0;
  try
    mSLog.Lines.Add('Receiving data form SGC Server');
    TCPClient.Write(strRequest.Text);
    //Read Connection and ended with '</SGC_SERVER>'
    while not TCPClient.ClosedGracefully do
    begin
      whileLimit:=whileLimit+1;
      try
        strTemp:=TCPClient.ReadLn;
        strReceive.Add(strTemp);
        if strTemp = '</SGC_SERVER>' then break;
      except
        break;
      end;
      if whileLimit > 1000000 then
      begin
        strTemp:='';
        break;
      end;
    end;
    mSLog.Lines.Add('Data received');
  except
    mSLog.Lines.Add('Error While Receiving Data');
  end;

end;

procedure TMain1.bConnectClick(Sender: TObject);
var tmpReceive:TStringList;
begin
  if bConnect.Caption = '&Connect' then
  begin
  	mSLog.Lines.Add('Try connect to SGC Server');
    try
      //Connect to SGC Server
      TCPClient.Host := eIPAddress.Text;
      TCPClient.Port := sePort1.Value;
      TCPClient.Connect;

      //Create temporary data
      tmpReceive:=TStringList.Create;

      //Sending command to SGC Server
      SendRequest(ClientString,tmpReceive);

      //Display XML Data
      Memo1.Lines.Text:= ClientString.Text;
      Memo2.Lines.Text:= tmpReceive.Text;

      //Free temporary data
      tmpReceive.Destroy;
      
    except
      mSLog.Lines.Add('Connection Failed');
    end;
  end
  else
  begin
    TCPClient.Disconnect;
  end;
end;

procedure TMain1.TCPClientConnected(Sender: TObject);
begin
  bConnect.Caption := '&Disconnect';
  eIPAddress.Enabled:=false;
  sePort1.Enabled:=false;
  bLogin.Enabled:=true;
  isConnected:=true;

  mSLog.Lines.Add('Connections is succeed');
end;

procedure TMain1.TCPClientDisconnected(Sender: TObject);
begin
  bConnect.Caption := '&Connect';
  eIPAddress.Enabled:=true;
  sePort1.Enabled:=true;
  bLogin.Enabled:=false;
  isLogin:=false;
  isConnected:=false;

  Memo1.Lines.Clear;
  Memo2.Lines.Clear;

  mSLog.Lines.Add('Disconnected form server');
end;

procedure TMain1.FormCreate(Sender: TObject);
begin
  ClientString:=TStringList.Create;
  ClientString.Add('<?xml version="1.0" encoding="utf-8"?>');
  ClientString.Add('<SGC_CLIENT DATE="' +FloatToStr(Date)+ '" TIME="' +FloatToStr(Time)+ '">');
  ClientString.Add('  <CLIENT_STRING COMMAND="Get Server String" USERNAME="" PASSWORD="" COMPANY_CODE="" PROGRAM_TYPE="" PROGRAM_CODE="" PARAMETER1="" PARAMETER2="" PARAMETER3=""/>');
  ClientString.Add('</SGC_CLIENT>');
  ClientString.Add(' ');//Add empty line after '</SGC_CLIENT>'


  {
    SGC Server has an authorization system. The authorization system will be blocked and limited the connection from any SGC Client connection.
    There are a several required field to Login and go through the authorization, such as :
    => USERNAME=""
    => PASSWORD=""
    => COMPANY_CODE=""
    => PROGRAM_TYPE=""
    => PROGRAM_CODE=""
    If the required fields value doesn't match with authorization configuration at SGC Server then the connection will be refuse (Login Failed).

    Assume that you are not login to SGC Server, then Login String always automaticaly filled with this value bellow :
    => USERNAME="DEMO"
    => PASSWORD="123456"
    => COMPANY_CODE="1000"
    => PROGRAM_TYPE="Examples"
    => PROGRAM_CODE="Client_Example_01"
  }
  //Set Default SGC Client Login for Demo Only
  cUserID:= 'DEMO';
  cPassword:= '123456';
  cCompanyCode:= '1000';
  cProgramType:= 'Examples';
  cProgramCode:= 'Client_Example_01';
  
  LoginString:=TStringList.Create;
  LoginString.Add('<?xml version="1.0" encoding="utf-8"?>');
  LoginString.Add('<SGC_CLIENT DATE="' +FloatToStr(Date)+ '" TIME="' +FloatToStr(Time)+ '">');
  LoginString.Add('  <CLIENT_STRING COMMAND="Login" '+
                                   'USERNAME="'+cUserID+'" '+
                                   'PASSWORD="'+cPassword+'" '+
                                   'COMPANY_CODE="'+cCompanyCode+'" '+
                                   'PROGRAM_TYPE="'+cProgramType+'" '+
                                   'PROGRAM_CODE="'+cProgramCode+'" '+
                                   'PARAMETER1="" PARAMETER2="" PARAMETER3=""/>');
  LoginString.Add('</SGC_CLIENT>');
  LoginString.Add(' ');//Add empty line after '</SGC_CLIENT>'

end;

procedure TMain1.bLoginClick(Sender: TObject);
var tmpReceive:TStringList;
begin
  //Create temporary data
  tmpReceive:=TStringList.Create;

  //Sending command to SGC Server
  SendRequest(LoginString,tmpReceive);

  //Display XML Data
  Memo1.Lines.Text:= LoginString.Text;
  Memo2.Lines.Text:= tmpReceive.Text;

  //Free temporary data
  tmpReceive.Destroy;

end;

end.
