'Class Name      : Client Socket (Revision 1)
'Compatible with : SGC Server v1.0, v1.1
'Created by Albertus Reinandang
'08-05-2008

Imports System
Imports System.IO
Imports System.Net
Imports System.Net.Sockets
Imports System.Net.Sockets.NetworkStream
Imports System.Text
Imports System.Xml

Public Class clsClientSocket
  Dim gvTCPClient As New System.Net.Sockets.TcpClient()
  Dim gvNetworkStream As NetworkStream
  Dim gvTimeOut As Integer
  Dim gvHost As String
  Dim gvPort As Int32

  Public Function Connect(ByVal Host As String, ByVal Port As Int32, ByVal TimeOut As Integer) As Boolean
    Try
      gvPort = Port
      gvHost = Host
      gvTCPClient.Connect(gvHost, gvPort)
      gvNetworkStream = gvTCPClient.GetStream()
    Catch ex As Exception

    End Try
    Connect = gvTCPClient.Connected()
  End Function

  Public Function Disconnect() As Boolean
    Try
      gvTCPClient.Close()
      gvTCPClient = Nothing
      gvNetworkStream = Nothing
      Disconnect = True
    Catch ex As Exception
      Disconnect = False
    End Try
  End Function

  Public Function isConnected() As Boolean
    Try
      isConnected = gvTCPClient.Connected
    Catch ex As Exception
    End Try

  End Function

  Public Function SendText(ByRef DisplayLog As TextBox, ByVal TextRequest As String, ByRef TextReplay As String) As Boolean
    Try
      If gvTCPClient.Connected And gvNetworkStream.CanWrite And gvNetworkStream.CanRead Then
        'Send XML Data to SGC Server
        Dim sendBytes As [Byte]() = Encoding.ASCII.GetBytes(TextRequest)
        gvNetworkStream.Write(sendBytes, 0, sendBytes.Length)

        ' Read the NetworkStream into a byte buffer.
        Dim readBuffer(1024) As Byte
        Dim strTemp As StringBuilder = New StringBuilder()
        Dim numberOfBytesRead As Integer = 0
        Dim maxReceiveData As Integer
        DisplayLog.Text = DisplayLog.Text & Environment.NewLine & "Receiving data form SGC Server"
        Do
          numberOfBytesRead = gvNetworkStream.Read(readBuffer, 0, readBuffer.Length)
          strTemp.AppendFormat("{0}", Encoding.ASCII.GetString(readBuffer, 0, numberOfBytesRead))

          '--If you want to limit received data for SGC Server
          'maxReceiveData = maxReceiveData + 1
          'If maxReceiveData = 100 Then
          '  Exit Do
          'End If
        Loop While gvNetworkStream.DataAvailable

        ' Output the data received from SGC Server to string.
        TextReplay = strTemp.ToString

        SendText = True
        DisplayLog.Text = DisplayLog.Text & Environment.NewLine & "Data received"
      Else
        TextReplay = ""
        SendText = False
      End If
    Catch ex As Exception

    End Try

  End Function

  Public Function SendTextToXMLDocument(ByRef DisplayLog As TextBox, ByVal TextRequest As String, ByRef XMLReplayDoc As XmlDocument) As Boolean
    Try
      If gvTCPClient.Connected And gvNetworkStream.CanWrite And gvNetworkStream.CanRead Then
        'Send XML Data to SGC Server
        Dim sendBytes As [Byte]() = Encoding.ASCII.GetBytes(TextRequest)
        gvNetworkStream.Write(sendBytes, 0, sendBytes.Length)

        ' Read the NetworkStream into a byte buffer.
        ' Incoming message may be larger than the buffer size.
        Dim readBuffer(1024) As Byte
        Dim strTemp As StringBuilder = New StringBuilder()
        Dim numberOfBytesRead As Integer = 0
        Dim maxReceiveData As Integer
        Do
          numberOfBytesRead = gvNetworkStream.Read(readBuffer, 0, readBuffer.Length)
          strTemp.AppendFormat("{0}", Encoding.ASCII.GetString(readBuffer, 0, numberOfBytesRead))

          '--If you want to limit received data for SGC Server
          'maxReceiveData = maxReceiveData + 1
          'If maxReceiveData = 100 Then
          '  Exit Do
          'End If
        Loop While gvNetworkStream.DataAvailable

        ' Output the data received from SGC Server to XMLDocument.
        Try
          XMLReplayDoc.LoadXml(strTemp.ToString)
        Catch ex As Exception
        End Try
        SendTextToXMLDocument = True
      Else
        SendTextToXMLDocument = False
      End If
    Catch ex As Exception

    End Try

  End Function

End Class
